	subroutine SHAPE(iout, idbg, Ne, Nn, Ng, V, ie, x, xg, e, &
			  Shp, dNdr, Wgt, J, Jac, Ji, Jaci, aopt)
! calculate element shape functions

	implicit none
	integer iout, idbg
	integer Ne, Nn, Ng			! array parameters
	integer ie(Ne,3)			! global connectivity array
	real*8 x(Nn,1)				! global coordinates array
	real*8 V(Ne,1) 		! global  arrays
	real*8 xg(Ng)				! Gauss abscissas [-1,+1]
	real*8 J(1,1,Ng,1), Ji(1,1,Ng,1), Jac(Ng,1), Jaci(Ng,1)	! geometric entities
	real*8 Shp(2,Ng,1), dNdr(2,1,Ng,1), Wgt(2,Ng,1)	! shape and weight functions
	real*8 aopt				! SUPG alpha_opt
	integer e

	integer i1, i2, g1, ierror
	real*8 r
	real*8 h, Vabs

	data ierror /0/

!	write(idbg,'(a)') ' --- SHAPE ---'	! ### TEMPORARY ###

	i1 = ie(e,1)			! 1st node
	i2 = ie(e,2)			! 2nd node
! assume the cell size, h, is the larger diagonal
	h = abs( x(i2,1) - x(i1,1) )	! element size
	Vabs = abs( V(e,1) )		! |Vi|

	do g1 = 1, Ng
	  r = xg(g1)

! linear 1D shape functions
! -1 < r < +1
! Ni(r) = (1 +/- r) / 2
	    Shp(1,g1,1) = 0.5d0 * (1.-r)	! N1(r)
	    Shp(2,g1,1) = 0.5d0 * (1.+r)	! N2(r)

	    dNdr(1,1,g1,1) =-0.5d0		! dN1(r)/dr
	    dNdr(2,1,g1,1) = 0.5d0		! dN2(r)/dr

! Jij is the Jacobian matrix
	    J(1,1,g1,1) = dNdr(1,1,g1,1)*x(i1,1) + dNdr(2,1,g1,1)*x(i2,1)	! x,r

	    Jac (g1,1) = J(1,1,g1,1)		! Jacobian determinant, |J|
	    Jaci(g1,1) = 1. / Jac(g1,1)		! 1/|J|

! inv(Jij)
	    Ji(1,1,g1,1) = Jaci(g1,1)

! Wi(r)
	    Wgt(1,g1,1) =  Shp(1,g1,1) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(1,1,g1,1)*V(e,1)*Ji(1,1,g1,1) )	! W1(r)
	    Wgt(2,g1,1) =  Shp(2,g1,1) + 0.5d0 * aopt * h / Vabs * &
			    ( dNdr(2,1,g1,1)*V(e,1)*Ji(1,1,g1,1) )	! W2(r)
! check element geometry
	    if(Jac(g1,1) .le. 0.) then
	      write(iout,*) '*** ABORT: Jac(g1,1) <= 0, e, g1, 1, Jac(g1,1) = ', &
							 e ,g1, 1, Jac(g1,1)
	      ierror = ierror + 1
	    endif

	enddo	! g1

	if(ierror .ne. 0) then
	  write(iout,*) '*** ABORT: ierror = ', ierror
	  stop
	endif
	
	return
	end
